#include <stdint.h>
#include <stdbool.h>
#include <stdio.h>
#include "hardware.h"

extern int test_convert( void );

// The adresses used in the #defines are defined in file hardware.h
// This file is generated by Altium Designer.
#define BITCOUNT (*((uint32_t volatile *)Base_wb_single))
#define DO_SQR   (*((float volatile *)Base_sqrctrl))

// Interface to swap() implemented in file swap.c
// Due to its calling qualifier the static stack of this function is
// mapped at address 0xFF000000.
__rtl __export __CC(wishbone, 0) uint32_t swap(uint32_t DAT_IN)
{
    // Empty function definition required
}


int main(int argc, char ** argv)
{
    volatile long    temp = 0;
    volatile long    sum = 0;
    volatile int     i = 0xfff;
    volatile int     ten = 0;
    volatile float   sqr_result_1;
    volatile float   sqr_result_2;
    volatile float   sqr_result_3;
    volatile float   sqr_result_4;
    volatile float   sqr_result_5;

    // Access C Code Symbol WB_SINGLE
    while(i)
    {
        BITCOUNT = i;
        sum += BITCOUNT;
        --i;
    }
    // sum should have value 6*0x1000 here

    // Access C Code Symbol WB_MULTI
    i = 0xfff;
    sum = 0;
    while(i)
    {
        temp = swap(i);
        BITCOUNT = temp;
        sum += BITCOUNT;
        --i;
    }
    // sum should again have value 6*0x1000 here

    // Access C Code Symbol WB_MULTI_MANUAL
    ten = test_convert();
    // ten should have value 10

    // Access C Code Symbol SQRCTRL
    DO_SQR = 2.0;
    DO_SQR = 1.001;
    DO_SQR = 3.14;
    DO_SQR = 3.0;
    DO_SQR = 2.718281828459;

    sqr_result_1 = DO_SQR;
    sqr_result_2 = DO_SQR;
    sqr_result_3 = DO_SQR;
    sqr_result_4 = DO_SQR;
    sqr_result_5 = DO_SQR;

    // Loop forever
    while(1)
    {
        i++;
    }
}
